package InputRead;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import dtelements.Attribute;
import dtelements.Example;

public class ReadDataFile {

	// attributes must come before examples
	// domains should be non empty
	public static void readFile(ArrayList<Attribute> attributes, ArrayList<Example> examples, String[] classLabels, String fileName)
	{
		try {
			BufferedReader readFile = new BufferedReader(new FileReader(fileName));
			int exampleID = 1;
			
			String line;
			while((line = readFile.readLine()) != null)
			{
				String trimmedLine = line.trim().replaceAll("\\s+", " ");
				if(trimmedLine.substring(0, 2).equals("//"))
				{
					// do nothing
				}
				else if(trimmedLine.substring(0, 2).equals("%%"))
				{
					String[] values = trimmedLine.split(",");
					classLabels[0] = values[1];
					classLabels[1] = values[2];
				}
				else if(trimmedLine.substring(0, 2).equals("##"))
				{
					String[] values = trimmedLine.split(",");
					ArrayList<String> domain = new ArrayList<String>();
					String attributeName = values[1];
					for(int i = 2; i < values.length; i++)
					{
						domain.add(values[i]);
					}
					
					attributes.add(new Attribute(attributeName, domain));
				}
				
				else
				{
					String[] values = trimmedLine.split(",");
					
					Example example = new Example(exampleID);
					exampleID++;
					
					for(int i = 1; i < values.length; i++)
					{
						example.addAttributeValue(attributes.get(i-1), values[i]);
					}
					
					if(values[0].equals(classLabels[0]))
					{
						example.setClassValue(false);
					}
					else
					{
						example.setClassValue(true);
					}
					examples.add(example);
					
				}
			}
			
			
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
}
